package ru.yandex.direct.metrika.client.model.request;

import java.util.List;

/**
 * A group of retargeting goals, as used in queries
 */
public class RetargetingGoalGroup {
    private final Type type;
    private final List<RetargetingGoal> goals;

    public RetargetingGoalGroup(Type type, List<RetargetingGoal> goals) {
        this.type = type;
        this.goals = goals;
    }

    public Type getType() {
        return type;
    }

    public List<RetargetingGoal> getGoals() {
        return goals;
    }

    /**
     * The group type
     */
    public enum Type {
        /** Condition matches if any goal matches */
        OR(" or "),
        /** Condition matches if all goals match */
        ALL(" and "),
        /** Condition matches if none of goals match */
        NOT(" and ", "not ");

        private final String joiner;
        private final String goalPrefix;

        Type(String joiner) {
            this.joiner = joiner;
            this.goalPrefix = "";
        }

        Type(String joiner, String goalPrefix) {
            this.joiner = joiner;
            this.goalPrefix = goalPrefix;
        }

        public String getJoiner() {
            return joiner;
        }

        public String getGoalPrefix() {
            return goalPrefix;
        }
    }
}
