package ru.yandex.direct.metrika.client.model.request;

import java.util.List;
import java.util.Objects;

public class UserCountersExtendedFilter {
    private List<Long> counterIds;
    private String prefix;
    private Integer limit;

    public List<Long> getCounterIds() {
        return counterIds;
    }

    public UserCountersExtendedFilter withCounterIds(List<Long> counterIds) {
        this.counterIds = counterIds;
        return this;
    }

    public String getPrefix() {
        return prefix;
    }

    public UserCountersExtendedFilter withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public Integer getLimit() {
        return limit;
    }

    public UserCountersExtendedFilter withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserCountersExtendedFilter that = (UserCountersExtendedFilter) o;
        return Objects.equals(counterIds, that.counterIds)
                && Objects.equals(prefix, that.prefix)
                && Objects.equals(limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(counterIds, prefix, limit);
    }
}
