package ru.yandex.direct.metrika.client.model.response;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * An abstract result to an access granting request
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "result")
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonSubTypes({@JsonSubTypes.Type(AddGrantResultOk.class), @JsonSubTypes.Type(AddGrantResultErr.class)})
public class AddGrantResult {
    private String objectId;

    public String getObjectId() {
        return objectId;
    }

    public AddGrantResult withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }
}
