package ru.yandex.direct.metrika.client.model.response;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * An error result to an access granting request
 */
@JsonTypeName("error")
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class AddGrantResultErr extends AddGrantResult {
    private String errorText;
    private String errorCode;

    public String getErrorText() {
        return errorText;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public AddGrantResultErr withErrorText(String errorText) {
        this.errorText = errorText;
        return this;
    }

    public AddGrantResultErr withErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}
