package ru.yandex.direct.metrika.client.model.response;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * An ok result to an access granting request
 */
@JsonTypeName("ok")
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class AddGrantResultOk extends AddGrantResult {
    private int grantsAffected;

    public int getGrantsAffected() {
        return grantsAffected;
    }

    public AddGrantResultOk withGrantsAffected(int grantsAffected) {
        this.grantsAffected = grantsAffected;
        return this;
    }
}
