package ru.yandex.direct.metrika.client.model.response;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Модель для получения счётчиков метрики.
 * <p>
 * Не путать с {@link UserCounters} — тот класс используется для запросов в IntApi метрики.
 * Эта модель используется для доступа к публичному API.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Counter {
    private int id;

    @JsonProperty("owner_login")
    private String ownerLogin;

    private String domain;

    private Set<String> features;

    public int getId() {
        return id;
    }

    public Counter withId(int id) {
        this.id = id;
        return this;
    }

    public String getOwnerLogin() {
        return ownerLogin;
    }

    public Counter withOwnerLogin(String ownerLogin) {
        this.ownerLogin = ownerLogin;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public Counter withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @SuppressWarnings("unused") // Used for deserialization of metrika response
    @JsonProperty("site2")
    public void unpackDomain(Map<String, String> site2Properties) {
        domain = site2Properties.get("site");
    }

    public Set<String> getFeatures() {
        return features;
    }

    public Counter withFeatures(Set<String> features) {
        this.features = features;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Counter counter = (Counter) o;
        return id == counter.id &&
                Objects.equals(domain, counter.domain);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, domain);
    }
}
