package ru.yandex.direct.metrika.client.model.response;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A description of a single goal for a counter
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class CounterGoal {
    private int id;
    private Long parentId;
    private String name;
    private Type type;
    private Status status;
    private Source source;
    private BigDecimal defaultPrice;

    public int getId() {
        return id;
    }

    public CounterGoal withId(int id) {
        this.id = id;
        return this;
    }

    public Long getParentId() {
        return parentId;
    }

    public CounterGoal withParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    public String getName() {
        return name;
    }

    public CounterGoal withName(String name) {
        this.name = name;
        return this;
    }

    public Type getType() {
        return type;
    }

    public CounterGoal withType(Type type) {
        this.type = type;
        return this;
    }

    public Status getStatus() {
        return status;
    }

    public CounterGoal withStatus(Status status) {
        this.status = status;
        return this;
    }

    public Source getSource() {
        return source;
    }

    public CounterGoal withSource(Source source) {
        this.source = source;
        return this;
    }

    public BigDecimal getDefaultPrice() {
        return defaultPrice;
    }

    public CounterGoal withDefaultPrice(BigDecimal defaultPrice) {
        this.defaultPrice = defaultPrice;
        return this;
    }

    public enum Type {
        URL("url"),
        NUMBER("number"),
        STEP("step"),
        ACTION("action"),
        OFFLINE("offline"),
        CALL("call"),
        PHONE("phone"),
        EMAIL("email"),
        FORM("form"),
        CDP_ORDER_IN_PROGRESS("cdp_order_in_progress"),
        CDP_ORDER_PAID("cdp_order_paid"),
        MESSENGER("messenger"),
        FILE("file"),
        SEARCH("search"),
        BUTTON("button"),
        E_CART("e_cart"),
        E_PURCHASE("e_purchase"),
        A_CART("a_cart"),
        A_PURCHASE("a_purchase"),
        CONDITIONAL_CALL("conditional_call"),
        SOCIAL("social"),
        PAYMENT_SYSTEM("payment_system"),
        CONTACT_DATA("contact_data"),
        @JsonEnumDefaultValue
        UNKNOWN("unknown");

        private final String value;

        Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }
    }

    /**
     * Копия
     * <a href="https://a.yandex-team.ru/arcadia/metrika/java/api/management-common/src/java/ru/yandex/metrika/api/management/client/external/goals/GoalStatus.java?rev=r9388014#L8">
     *     ru.yandex.metrika.api.management.client.external.goals.GoalStatus</a>
     */
    public enum Status {
        ACTIVE("Active"),
        DELETED("Deleted"),
        HIDDEN("Hidden");

        private final String value;

        Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }
    }

    public enum Source {
        USER("user"),
        AUTO("auto"),
        @JsonEnumDefaultValue
        UNKNOWN("unknown");

        private final String value;

        Source(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }
    }
}
