package ru.yandex.direct.metrika.client.model.response;

import java.util.Objects;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class CounterInfoDirect {
    private int id;
    private String name;
    private String sitePath;
    private String counterSource;
    private String counterPermission;
    private boolean ecommerce;

    public int getId() {
        return id;
    }

    public CounterInfoDirect withId(int id) {
        this.id = id;
        return this;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public CounterInfoDirect withName(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSitePath() {
        return sitePath;
    }

    public CounterInfoDirect withSitePath(String sitePath) {
        this.sitePath = sitePath;
        return this;
    }

    public void setSitePath(String sitePath) {
        this.sitePath = sitePath;
    }

    public String getCounterSource() {
        return counterSource;
    }

    public CounterInfoDirect withCounterSource(String counterSource) {
        this.counterSource = counterSource;
        return this;
    }

    public void setCounterSource(String counterSource) {
        this.counterSource = counterSource;
    }

    public String getCounterPermission() {
        return counterPermission;
    }

    public void setCounterPermission(String counterPermission) {
        this.counterPermission = counterPermission;
    }

    public CounterInfoDirect withCounterPermission(String counterPermission) {
        this.counterPermission = counterPermission;
        return this;
    }

    public boolean getEcommerce() {
        return ecommerce;
    }

    public CounterInfoDirect withEcommerce(boolean ecommerce) {
        this.ecommerce = ecommerce;
        return this;
    }

    public void setEcommerce(boolean ecommerce) {
        this.ecommerce = ecommerce;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CounterInfoDirect that = (CounterInfoDirect) o;
        return id == that.id &&
                Objects.equals(name, that.name) &&
                Objects.equals(sitePath, that.sitePath) &&
                Objects.equals(counterSource, that.counterSource) &&
                Objects.equals(counterPermission, that.counterPermission);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, sitePath, counterSource, counterPermission);
    }
}
