package ru.yandex.direct.metrika.client.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * A description of a single goal for a counter
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateCounterGoal {

    private Long id;
    private String name;
    private CounterGoal.Type type;
    private boolean isRetargeting;
    private String flag;

    private List<GoalCondition> conditions;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CreateCounterGoal withId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateCounterGoal withName(String name) {
        this.name = name;
        return this;
    }

    public CounterGoal.Type getType() {
        return type;
    }

    public void setType(CounterGoal.Type type) {
        this.type = type;
    }

    public CreateCounterGoal withType(CounterGoal.Type type) {
        this.type = type;
        return this;
    }

    public boolean isRetargeting() {
        return isRetargeting;
    }

    public void setRetargeting(boolean retargeting) {
        isRetargeting = retargeting;
    }

    public CreateCounterGoal withRetargeting(boolean retargeting) {
        isRetargeting = retargeting;
        return this;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public CreateCounterGoal withFlag(String flag) {
        this.flag = flag;
        return this;
    }

    public List<GoalCondition> getConditions() {
        return conditions;
    }

    public void setConditions(List<GoalCondition> conditions) {
        this.conditions = conditions;
    }

    public CreateCounterGoal withConditions(List<GoalCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public static class GoalCondition {
        private GoalConditionType type;

        private String url;

        public GoalConditionType getType() {
            return type;
        }

        public void setType(GoalConditionType type) {
            this.type = type;
        }

        public GoalCondition withType(GoalConditionType conditionType) {
            this.type = conditionType;
            return this;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public GoalCondition withUrl(String url) {
            this.url = url;
            return this;
        }
    }
};


