package ru.yandex.direct.metrika.client.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class GetCountersGoalsResponse {
    private List<CounterGoalExtended> goals;

    @JsonCreator
    public GetCountersGoalsResponse(@JsonProperty("goals") List<CounterGoalExtended> goals) {
        this.goals = goals;
    }

    public List<CounterGoalExtended> getGoals() {
        return goals;
    }

    public void setGoals(List<CounterGoalExtended> goals) {
        this.goals = goals;
    }
}
