package ru.yandex.direct.metrika.client.model.response;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class GetExistentCountersResponseItem {

    @JsonProperty("counter_id")
    private Long counterId;

    @JsonProperty("counter_source")
    private String counterSource;

    @JsonProperty("direct_allow_use_goals_without_access")
    private Boolean allowUseGoalsWithoutAccess;

    @JsonProperty("ecommerce")
    private Boolean ecommerce;

    public Long getCounterId() {
        return counterId;
    }

    public String getCounterSource() {
        return counterSource;
    }

    public Boolean getAllowUseGoalsWithoutAccess() {
        return allowUseGoalsWithoutAccess;
    }

    public Boolean getEcommerce() {
        return ecommerce;
    }

    public GetExistentCountersResponseItem withCounterId(Long counterId) {
        this.counterId = counterId;
        return this;
    }

    public GetExistentCountersResponseItem withCounterSource(String counterSource) {
        this.counterSource = counterSource;
        return this;
    }

    public GetExistentCountersResponseItem withAllowUseGoalsWithoutAccess(Boolean allowUseGoalsWithoutAccess) {
        this.allowUseGoalsWithoutAccess = allowUseGoalsWithoutAccess;
        return this;
    }

    public GetExistentCountersResponseItem withEcommerce(Boolean ecommerce) {
        this.ecommerce = ecommerce;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExistentCountersResponseItem)) {
            return false;
        }
        GetExistentCountersResponseItem that = (GetExistentCountersResponseItem) o;
        return Objects.equals(counterId, that.counterId) &&
                Objects.equals(counterSource, that.counterSource) &&
                Objects.equals(allowUseGoalsWithoutAccess, that.allowUseGoalsWithoutAccess) &&
                Objects.equals(ecommerce, that.ecommerce);
    }

    @Override
    public int hashCode() {
        return Objects.hash(counterId, counterSource, allowUseGoalsWithoutAccess, ecommerce);
    }
}
