package ru.yandex.direct.metrika.client.model.response;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class GoalConversionInfo {
    private Long goalId;
    private Long count;
    private Boolean hasPrice;

    public GoalConversionInfo() {
    }

    public GoalConversionInfo(Long goalId, Long count, Boolean hasPrice) {
        this.goalId = goalId;
        this.count = count;
        this.hasPrice = hasPrice;
    }

    public Long getGoalId() {
        return goalId;
    }

    public void setGoalId(Long goalId) {
        this.goalId = goalId;
    }

    public Long getCount() {
        return count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public Boolean isHasPrice() {
        return hasPrice;
    }

    public void setHasPrice(Boolean hasPrice) {
        this.hasPrice = hasPrice;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GoalConversionInfo that = (GoalConversionInfo) o;
        return Objects.equals(goalId, that.goalId) &&
                Objects.equals(count, that.count) &&
                Objects.equals(hasPrice, that.hasPrice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goalId, count, hasPrice);
    }
}
