package ru.yandex.direct.metrika.client.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class GoalConversionsCountResponse {
    private List<ResponseItem> response;

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class ResponseItem {
        private int counterId;
        private List<GoalConversionInfo> counts;

        public int getCounterId() {
            return counterId;
        }

        public void setCounterId(int counterId) {
            this.counterId = counterId;
        }

        public List<GoalConversionInfo> getCounts() {
            return counts;
        }

        public void setCounts(List<GoalConversionInfo> counts) {
            this.counts = counts;
        }
    }

    public List<ResponseItem> getResponse() {
        return response;
    }

    public void setResponse(List<ResponseItem> response) {
        this.response = response;
    }
}
