package ru.yandex.direct.metrika.client.model.response;

import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class GoalData {
    private long id;
    private String name;
    private CounterGoal.Type type;
    private CounterGoal.Status status;
    private CounterGoal.Source goalSource;
    private BigDecimal defaultPrice;
    private int isRetargeting;
    private long prevGoalId;
    private List<GoalData> steps;

    public long getId() {
        return id;
    }

    public GoalData withId(long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public GoalData withName(String name) {
        this.name = name;
        return this;
    }

    public CounterGoal.Type getType() {
        return type;
    }

    public GoalData withType(CounterGoal.Type type) {
        this.type = type;
        return this;
    }

    public CounterGoal.Status getStatus() {
        return status;
    }

    public GoalData withStatus(CounterGoal.Status status) {
        this.status = status;
        return this;
    }

    public CounterGoal.Source getGoalSource() {
        return goalSource;
    }

    public GoalData withGoalSource(CounterGoal.Source goalSource) {
        this.goalSource = goalSource;
        return this;
    }

    public BigDecimal getDefaultPrice() {
        return defaultPrice;
    }

    public GoalData withDefaultPrice(BigDecimal defaultPrice) {
        this.defaultPrice = defaultPrice;
        return this;
    }

    public int getIsRetargeting() {
        return isRetargeting;
    }

    public GoalData withIsRetargeting(int isRetargeting) {
        this.isRetargeting = isRetargeting;
        return this;
    }

    public long getPrevGoalId() {
        return prevGoalId;
    }

    public GoalData withPrevGoalId(long prevGoalId) {
        this.prevGoalId = prevGoalId;
        return this;
    }

    public List<GoalData> getSteps() {
        return steps;
    }

    public GoalData withSteps(List<GoalData> steps) {
        this.steps = steps;
        return this;
    }

}
