package ru.yandex.direct.metrika.client.model.response;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import ru.yandex.direct.metrika.client.MetrikaApiError;

/**
 * A decoded error response from metrika
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MetrikaErrorResponse {
    private List<MetrikaApiError> errors;
    private int code;
    private String message;

    @JsonCreator
    public MetrikaErrorResponse(@JsonProperty("errors") List<MetrikaApiError> errors, @JsonProperty("code") int code,
            @JsonProperty("message") String message)
    {
        this.errors = errors;
        this.code = code;
        this.message = message;
    }

    public List<MetrikaApiError> getErrors() {
        return errors;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MetrikaErrorResponse that = (MetrikaErrorResponse) o;
        return code == that.code &&
                Objects.equals(errors, that.errors) &&
                Objects.equals(message, that.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(errors, code, message);
    }

    @Override
    public String toString() {
        return "MetrikaErrorResponse{" +
                "errors=" + errors +
                ", code=" + code +
                ", message='" + message + '\'' +
                '}';
    }
}
