package ru.yandex.direct.metrika.client.model.response;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.collect.ImmutableMap;

/**
 * A retargeting condition as returned from metrika
 */
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class RetargetingCondition {

    // SegmentContentType
    public static final String SUBTYPE_UPLOADING_EMAIL = "uploading_email";
    public static final String SUBTYPE_UPLOADING_PHONE = "uploading_phone";
    public static final String SUBTYPE_UPLOADING_IDFA_GAID = "uploading_idfa_gaid";
    public static final String SUBTYPE_URL_EMAIL = "url_email";
    public static final String SUBTYPE_URL_PHONE = "url_phone";
    public static final String SUBTYPE_URL_IDFA_GAID = "url_idfa_gaid";
    // SegmentType
    public static final String SUBTYPE_LOOKALIKE = "lookalike";
    // MetrikaSegmentType
    public static final String SUBTYPE_METRIKA_COUNTER_ID = "metrika_counter_id";
    public static final String SUBTYPE_METRIKA_GOAL_ID = "metrika_goal_id";
    public static final String SUBTYPE_METRIKA_SEGMENT_ID = "metrika_segment_id";
    // AppMetricaSegmentType
    public static final String SUBTYPE_APPMETRIKA_API_KEY = "appmetrica_api_key";
    public static final String SUBTYPE_APPMETRIKA_SEGMENT_ID = "appmetrica_segment_id";
    // GeoSegmentType
    public static final String SUBTYPE_GEO_LAST = "geo_last";
    public static final String SUBTYPE_GEO_REGULAR = "geo_regular";
    public static final String SUBTYPE_GEO_CONDITION = "geo_condition";
    // CompositionType
    public static final String SUBTYPE_COMPOSITION_UNION = "composition_union";
    public static final String SUBTYPE_COMPOSITION_INTERSECT = "composition_intersect";
    public static final String SUBTYPE_COMPOSITION_SUBSTRACT = "composition_subtract";

    private long id;
    private String name;
    private long owner;
    private Type type;
    private String goalSubtype;
    private int counterId;
    private List<Integer> counterIds;
    private String counterDomain;
    private String counterName;
    private String uploadingSourceId;
    private Long sectionId;
    private String sectionName;
    private int  percent;

    public long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public long getOwner() {
        return owner;
    }

    public Type getType() {
        return type;
    }

    public String getGoalSubtype() {
        return goalSubtype;
    }

    public int getCounterId() {
        return counterId;
    }

    public String getCounterDomain() {
        return counterDomain;
    }

    public String getCounterName() {
        return counterName;
    }

    public String getUploadingSourceId() {
        return uploadingSourceId;
    }

    public List<Integer> getCounterIds() {
        return counterIds;
    }

    public Long getSectionId() {
        return sectionId;
    }

    public String getSectionName() {
        return sectionName;
    }

    public int getPercent() {
        return percent;
    }

    public RetargetingCondition withId(long id) {
        this.id = id;
        return this;
    }

    public RetargetingCondition withName(String name) {
        this.name = name;
        return this;
    }

    public RetargetingCondition withOwner(long owner) {
        this.owner = owner;
        return this;
    }

    public RetargetingCondition withType(Type type) {
        this.type = type;
        return this;
    }

    public RetargetingCondition withGoalSubtype(String goalSubtype) {
        this.goalSubtype = goalSubtype;
        return this;
    }

    public RetargetingCondition withCounterId(int counterId) {
        this.counterId = counterId;
        return this;
    }

    public RetargetingCondition withCounterDomain(String counterDomain) {
        this.counterDomain = counterDomain;
        return this;
    }

    public RetargetingCondition withCounterName(String counterName) {
        this.counterName = counterName;
        return this;
    }

    public RetargetingCondition withUploadingSourceId(String uploadingSourceId) {
        this.uploadingSourceId = uploadingSourceId;
        return this;
    }

    public RetargetingCondition withCounterIds(List<Integer> counterIds) {
        this.counterIds = counterIds;
        return this;
    }

    public RetargetingCondition withSectionId(Long sectionId) {
        this.sectionId = sectionId;
        return this;
    }

    public RetargetingCondition withSectionName(String sectionName) {
        this.sectionName = sectionName;
        return this;
    }

    public RetargetingCondition withPercent(int percent) {
        this.percent = percent;
        return this;
    }

    @Override
    public String toString() {
        return "RetargetingCondition{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", owner=" + owner +
                ", type=" + type +
                ", goalSubtype=" + goalSubtype +
                ", counterId=" + counterId +
                ", counterDomain='" + counterDomain + '\'' +
                ", counterName='" + counterName + '\'' +
                ", uploadingSourceId=" + uploadingSourceId +
                '}';
    }

    /**
     * A type of retargeting condition as returned from metrika
     */
    public enum Type {
        GOAL("goal"),
        SEGMENT("segment"),
        ECOMMERCE("ecommerce"),
        AUDIENCE("audience"),
        AB_SEGMENT("ab_segment"),
        CDP_SEGMENT("cdp_segment"),
        UNKNOWN("unknown");

        private final String value;
        private static final ImmutableMap<String, Type> ENUM_MAP;

        Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @JsonCreator
        public static Type fromString(String value) {
            Type result = ENUM_MAP.get(value);
            if (result != null) {
                return result;
            }
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            return UNKNOWN;
        }

        static {
            Map<String, Type> map = new ConcurrentHashMap<>();
            for (Type instance : Type.values()) {
                map.put(instance.getValue(), instance);
            }
            ENUM_MAP = ImmutableMap.copyOf(map);
        }
    }
}
