package ru.yandex.direct.metrika.client.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Segment {
    @JsonProperty("segment_id")
    private int id;

    @JsonProperty("counter_id")
    private int counterId;

    private String name;
    private String expression;

    public int getId() {
        return id;
    }

    public int getCounterId() {
        return counterId;
    }

    public String getName() {
        return name;
    }

    public String getExpression() {
        return expression;
    }

    public Segment withId(int id) {
        this.id = id;
        return this;
    }

    public Segment withCounterId(int counterId) {
        this.counterId = counterId;
        return this;
    }

    public Segment withName(String name) {
        this.name = name;
        return this;
    }

    public Segment withExpression(String expression) {
        this.expression = expression;
        return this;
    }
}
