package ru.yandex.direct.metrika.client.model.response;

import java.util.List;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import static java.util.stream.Collectors.joining;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class UserCounters {
    private long owner;
    private int countersCnt;
    private List<Integer> counterIds;

    public long getOwner() {
        return owner;
    }

    public int getCountersCnt() {
        return countersCnt;
    }

    public List<Integer> getCounterIds() {
        return counterIds;
    }

    public UserCounters withOwner(long owner) {
        this.owner = owner;
        return this;
    }

    public UserCounters withCountersCnt(int countersCnt) {
        this.countersCnt = countersCnt;
        return this;
    }

    public UserCounters withCounterIds(List<Integer> counterIds) {
        this.counterIds = counterIds;
        return this;
    }

    @Override
    public String toString() {
        return "{" +
                "owner=" + owner +
                ", countersCnt=" + countersCnt +
                ", counterIds=" +
                counterIds.stream().map(Object::toString).collect(joining(", ", "{", "}")) +
                '}';
    }
}
