package ru.yandex.direct.metrika.client.model.response;

import java.util.List;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class UserCountersExtended {
    private long owner;
    private int countersCnt;
    private List<CounterInfoDirect> counters;

    public long getOwner() {
        return owner;
    }

    public int getCountersCnt() {
        return countersCnt;
    }

    public List<CounterInfoDirect> getCounters() {
        return counters;
    }

    public UserCountersExtended withOwner(long owner) {
        this.owner = owner;
        return this;
    }

    public UserCountersExtended withCountersCnt(int countersCnt) {
        this.countersCnt = countersCnt;
        return this;
    }

    public UserCountersExtended withCounters(List<CounterInfoDirect> counters) {
        this.counters = counters;
        return this;
    }
}
