package ru.yandex.direct.libs.mirrortools;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.io.Resources;

/**
 * Configuration class for mirror tools.
 * <p>
 * HostingUtils:
 * hostingsFilename - filename for known hostings list
 * publicSecondLevelDomainsFileName - filename for known public second level domains list
 * </p>
 */

@ParametersAreNonnullByDefault
public class MirrorToolsConfig {
    private static final String HOSTINGS_FILENAME = "hostings.txt";
    private static final String PUBLIC_SECOND_LEVEL_DOMAINS_FILENAME =
            "publicsecondleveldomains.txt";

    private String hostingsFilename = HOSTINGS_FILENAME;
    private String publicSecondLevelDomainsFilename = PUBLIC_SECOND_LEVEL_DOMAINS_FILENAME;

    public MirrorToolsConfig withHostingsFilename(String fileName) {
        this.hostingsFilename = fileName;
        return this;
    }

    public MirrorToolsConfig withPublicSecondLevelDomainsFilename(String fileName) {
        this.publicSecondLevelDomainsFilename = fileName;
        return this;
    }

    private String getHostingsFilename() {
        return hostingsFilename;
    }

    private String getPublicSecondLevelDomainsFilename() {
        return publicSecondLevelDomainsFilename;
    }

    public List<String> getHostings() {
        return readFile(getHostingsFilename());
    }

    public List<String> getPublicSecondLevelDomains() {
        return readFile(getPublicSecondLevelDomainsFilename());
    }

    private static List<String> readFile(String fileName) {
        try {
            return Resources.readLines(Resources.getResource(fileName), StandardCharsets.UTF_8);
        } catch (IOException ioException) {
            throw new IllegalArgumentException("Incorrect file path: " + fileName);
        }
    }
}
