# Формат описания моделей

Для описания используется typesafe-config ([документация](https://github.com/typesafehub/config/blob/master/HOCON.md)).

Каждый файл описывает одну модель со всеми аттрибутами, enum-ами и ограничивающими интерфейсам,
пример можно посмотреть [тут](src/test/resources/examples/adgroup.conf).

## Атрибуты верхнего уровня (модели)

*Жирным отмечены обязательные атрибуты*
- **package** - имя java-пакета, в котором будет генерироваться модель, и пакет по-умолчанию для всех используемых типов
- **name** - имя класса модели
- extends - название класса, от которого надо унаследовать этот класс модели
- implements - список интерфейсов (не описанных в этом классе), которые будет реализовывать модель
- modifiers - по умолчанию [PUBLIC], список модификаторов, которые будут применены к классу, допустимые значения: ABSTRACT, PUBLIC
- comment - комментарий, который попадёт в javadoc к классу
- attrs - список полей модели, подробности - (#Атрибуты-модели)
- enums - список генерируемых перечислений (#Перечисления)
- interfaces - список генерируемых ограничивающих интерфейсов (#Ограничивающие-интерфейсы)
- generateProperties - по-умолчанию true - генерировать ли static-поля ModelProperty
- generateCopyMethod - по-умолчанию false - генерировать ли метод для копирование модели. Надо проставлять только для верхнего уровня класса, для всех наследников автоматом сгенерится метод
- annotated_by - список аннотаций модели (#Аннотации)


## Атрибуты модели

- **name** - имя атрибута
- **type** - тип атрибута - может быть класс из java.{lang,util,time,math}, из package модели или полное имя класса. Так же может быть примитивом, но тогда на уровне модели должно быть выключено generateProperties
- comment - комментарий, который попадёт в javadoc
- annotated_by - список аннотаций атрибута (#Аннотации)
- json - имя атрибута для сериализации в json, указание проаннотировать поле jackson аннотацией @JsonProperty("...")
- jsonInclude - условие включения атрибута при сериализации в json, стандартные варианты аннотации @JsonInclude(...) из пакета com.fasterxml.jackson.annotation. Допустим один из следующих типов: ALWAYS, NON_NULL, NON_ABSENT, NON_EMPTY, NON_DEFAULT, USE_DEFAULT
- jsonSubtypes - по умолчанию `false` - найти все классы, наследующие этот класс и создать аннотацию @JsonSubTypes
- aliasTo - если задан, создать геттер и сеттер, работающие с алиасом, а не с самим аттрибутом
- relationship - описание связи с другой моделью

### Атрибуты связи между объектами
- **name** - имя связи (будет, в том числе, именем класса связи)
- **parent** - имя класса-родителя (чей первичный ключ задается атрибутом, на котором висит связь)


### Ограничивающие интерфейсы

- **name** - имя интерфейса
- **attrs** - список имён атрибутов, доступных через этот интерфейс
- annotated_by - список аннотаций атрибута (#Аннотации)
- jsonSubtypes - по умолчанию `false` - создать аннотацию @JsonSubTypes со ссылкой на модель, для которой сгенерирован интерфейс
- extends - список имён интерфейсов, которые будет экстендить наш (их поля можно не перечислять в attrs)
- readonly - по умолчанию `true` - интерфейс будет сгенерирован только с геттерами, иначе еще с set- и with-методами для каждого аттрибута

### Перечисления

*обязательно указание values или valuesSource*

- **name** - имя перечисления
- *values* * - список значений - либо строк, либо словарей с ключами value и comment
- *valuesType* - (используется только с values, опционален) тип значения приписанного к перечислению
- *valuesSource* * - ссылка на enum, из которого нужно получить набор значение, перевести их в верхний регистр и
создать методы конвертации - toSource, fromSource. Enum должен быть доступен в classpath в момент генерации


### Атрибуты перечисления
- **value** - имя константы перечисления
- comment - комментарий, который попадёт в javadoc
- jsonProperty - имя атрибута для сериализации в json, указание проаннотировать элемент перечисления jackson аннотацией @JsonProperty("...")
- typedValue - значение приписанное к перечислению. Обязателен, если valuesType на уровне перечисления задан

### Методы перечисления
При заполнении valuesType и typedValue для каждого значения в перечислении также создаются методы:
- *getTypedValue()* - возвращает значение приписанное к перечислению
- *static fromTypedValue(T typedValue)* - возвращает перечисление, если найдено, null в случае typedValue == null и IllegalArgumentException, если значение не описано.

### Аннотации
- **type** - тип аннотации - может быть класс из java.{lang,util,time,math}, из package модели или полное имя класса.
- apply - только для аннотаций на полях класса. Обозначает, к какому представлению поля нужно применить аннотацию.
  Может принимать множество значений: `field`(только на поле), `getter`(только на геттер), `setter_parameter`(на параметр сеттера)
  По умолчанию используются `field` и `getter`
- params - список описаний параметров аннотации со следующими полями:
  - **key** - имя поля аннотации
  - **value** - значение поля аннотации, может быть числом, строкой, булевой переменной, списком вышеперечисленных типов или литералом
  - literal - `true`, если значение нужно интерпретировать как Java-литерал. В остальных случаях код старается сам
    определить тип значения и корректно проставить его в аннотацию

## Самостоятельные интерфейсы
Интерфейс может быть описан в отдельном файле.
ВАЖНО: имя файла, описывающего такой интерфейс, должно начинаться с 'i_'.

Например, `i_model.conf`

### Атрибуты самостоятельных интерфейсов
- **package** - имя java-пакета, в котором будет генерироваться интерфейс, и пакет по умолчанию для всех используемых типов
- **name** - имя интерфейса
- comment – комментарий, который попадёт в Javadoc
- extends - список имён интерфейсов, которые будет экстендить наш (их поля можно не перечислять в attrs)
- **attrs** – список атрибутов, доступных по этому интерфейсу
- generateProperties - по-умолчанию `true` - генерировать ли static-поля ModelProperty
- readonly - по умолчанию `true` - интерфейс будет сгенерирован только с геттерами, иначе еще с set- и with-методами для каждого аттрибута
- annotated_by - список аннотаций интерфейса (#Аннотации)
- jsonSubtypes - по умолчанию `false` - найти все классы, реализующие этот интерфейс и создать аннотацию @JsonSubTypes

## Самостоятельное описание связи между объектами
Связь между объектами (relationship) может быть описана в отдельном файле.
**Важно** имя файла должно начинаться с `r_`.

### Атрибуты самостоятельного описания связи между объектами
Все атрибуты обязательны.

- **package** - имя java-пакета, в котором будет сгенерирован класс-связь,
также пакет по умолчанию для всех используемых типов
- **name** - имя связи (будет, в том числе, именем класса связи)
- **parent** - имя класса-родителя
- **child** - имя дочернего класса (имеющего в атрибутах id родителя)
- **parentIdField** - имя поля **дочернего** класса, указывающего на primary key родителя
- **parentIdType** - тип поля `parentIdField`

## Самостоятельные перечисления
Перечисление (enum) может быть описано в отдельном файле.
**Важно** имя файла должно начинаться с `e_`.

Атрибуты перечислений описаны выше.
Кроме них в самостоятельном описании нужно указывать:
**package** - имя java-пакета, в котором будет сгенерировано перечисление

