# Генератор классов для Моделей Директа

### Зачем это нужно
Описывать Model на java - очень многословно - тяжело создавать ModelProperty, два вида сеттеров, equals/hashCode/toString. Ещё тяжелее поддерживать всё это при изменениях. А раз это тяжело - это приводит к ошибкам. Ещё одна проблема - внесение  программистом в модели дополнительной логики, наличие которой неинтуитивно (более сложные сеттеры/специализированные toString/...).

Нужен способ описывать модели легко и гарантированно одинаково - чтобы в работе было поменьше сюрпризов и wtf.

Если действительно нужно добавить какую-то отдельную логику в модель - можно отнаследоваться от сгенерированного класса и переопределить всё, что нужно.

### Что делает программа
Находит *.conf файлы в указанных директориях и создаёт описанные в них перечисления, классы, интерфейсы

Умеет использовать *.conf файлы из ClassPath (из ресурсов) — это нужно для правильной генерации моделей
в отдельный модуль, использующий модели другого (чтобы правильно учесть уже созданные PropHolder'ы).

### Особенность генерации
Чтобы избежать генерации большого количества *PropHolder'ов используется следующая логика:
- если класс реализует только интерфейсы PropHolder'ов, то соответствующие интерфейсы не генерируются, а константы переносятся внутрь класса.
- иначе интерфейсы будут созданы со всеми их методами и константами.

### Использование в Arcadia
Пример можно посмотреть в `direct/libs-internal/core-models` и `direct/bin/generate_models.sh`

Нужно:
- в ресурсах сделать директорию с конфигами  [описание формата](CONFIG_FORMAT.md)
- прописать RUN_JAVA_PROGRAM с запуском генератора
- прописать директорию со сгенерированными .java файлами в JAVA_SRCS

### FAQ

##### Почему конфигурация в typesafe-config?
- позволяет писать быстро (минимальное количество символов)
- позволяет инклюдить/наследовать/переиспользовать (может быть полезно)

Почему не JSON - конфиги получаются многословными, очень много кавычек, JsonSchema в Idea не особо помогает работать

Почему не XML - не модно-молодёжно
