package ru.yandex.direct.model.generator;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

/**
 * Параметры для cli-программы
 */
class ToolParams {
    @Parameter(
            names = {"-p", "--classpath-prefix"},
            description = "Package prefix for searching models conf in classpath"
    )
    String prefixToSearchConfInClasspath;

    @Parameter(
            names = {"-o", "--output-path"},
            required = true,
            description = "Where to place generated code"
    )
    String outputPath;

    @Parameter(
            names = {"-r", "--rewrite"},
            description = "Use rewrite"
    )
    Boolean rewrite;

    @Parameter(
            required = true,
            description = "<conf-dir> ..."
    )
    List<String> confDirs = new ArrayList<>();

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("ToolParams{");
        sb.append("prefixToSearchConfInClasspath='").append(prefixToSearchConfInClasspath).append('\'');
        sb.append("outputPath='").append(outputPath).append('\'');
        sb.append(", rewrite=").append(rewrite);
        sb.append(", confDirs=").append(confDirs);
        sb.append('}');
        return sb.toString();
    }
}
