package ru.yandex.direct.model.generator.old.conf;

import javax.annotation.ParametersAreNonnullByDefault;

import com.typesafe.config.Config;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.model.generator.old.conf.EnumValueConf.SourceProperty.COMMENT;
import static ru.yandex.direct.model.generator.old.conf.EnumValueConf.SourceProperty.JSON_PROPERTY;
import static ru.yandex.direct.model.generator.old.conf.EnumValueConf.SourceProperty.TYPED_VALUE;
import static ru.yandex.direct.model.generator.old.conf.EnumValueConf.SourceProperty.VALUE;

@ParametersAreNonnullByDefault
public class EnumValueConf {

    static class SourceProperty {
        static final String COMMENT = "comment";
        static final String JSON_PROPERTY = "jsonProperty";
        static final String TYPED_VALUE = "typedValue";
        static final String VALUE = "value";

        private SourceProperty() {
        }
    }

    private final String value;
    private final String comment;
    private final String typedValue;
    private final String jsonProperty;

    public EnumValueConf(String value, String comment, String typedValue, String jsonProperty) {
        this.value = checkNotNull(value);
        this.comment = checkNotNull(comment);
        this.typedValue = checkNotNull(typedValue);
        this.jsonProperty = jsonProperty;
    }

    public static EnumValueConf fromConfig(Config config) {
        return new Builder(config.getString(VALUE))
                .withComment(config.hasPath(COMMENT) ? config.getString(COMMENT) : "")
                .withTypedValue(config.hasPath(TYPED_VALUE) ? config.getString(TYPED_VALUE) : "")
                .withJson(config.hasPath(JSON_PROPERTY) ? config.getString(JSON_PROPERTY) : "")
                .build();
    }

    public String getValue() {
        return value;
    }

    public String getComment() {
        return comment;
    }

    public String getTypedValue() {
        return typedValue;
    }

    public String getJsonProperty() {
        return jsonProperty;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("EnumValueConf{");
        sb.append(VALUE).append("='").append(value).append('\'');
        sb.append(", ").append(COMMENT).append("='").append(comment).append('\'');
        sb.append(", ").append(TYPED_VALUE).append("='").append(typedValue).append('\'');
        sb.append(", ").append(JSON_PROPERTY).append("='").append(jsonProperty).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private String value;
        private String comment = "";
        private String typedValue = "";
        private String jsonProperty = "";

        public Builder(String value) {
            this.value = value;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withTypedValue(String typedValue) {
            this.typedValue = typedValue;
            return this;
        }

        public Builder withJson(String jsonProperty) {
            this.jsonProperty = jsonProperty;
            return this;
        }

        public EnumValueConf build() {
            return new EnumValueConf(value, comment, typedValue, jsonProperty);
        }
    }
}
