package ru.yandex.direct.model.generator.old.conf;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.ClassName;

import ru.yandex.direct.model.generator.old.util.FullClassNameProvider;

/**
 * Описание модели обладающее своим spec-ом, т.е. в результате преобразуемое в файл.
 */
@ParametersAreNonnullByDefault
public interface ModelConf extends FullClassNameProvider {

    enum Type {
        /**
         * Обычное описание класса модели. Возможны вложенные описания интерфейсов и enum-ов.
         */
        CLASS,
        /**
         * Описание модельного интерфейса.
         */
        INTERFACE,
        /**
         * Описание Enum.
         */
        ENUM,
        /**
         * Описание модели Relationship
         */
        RELATIONSHIP_MODEL
    }

    /**
     * @return Тип описания.
     */
    Type getType();

    /**
     * @return Короткое имя класса.
     */
    String getName();

    /**
     * @return Полное имя пакета.
     */
    String getPackageName();

    /**
     * @return Комментарий, указанный в исходнике, для генерации Javadoc.
     */
    String getComment();

    /**
     * @return Имя класса в виде инстанса {@link ClassName}.
     */
    ClassName getClassName();

    /**
     * @return Список аннотаций, явно указанных в описании этой модели, в виде инстансов {@link AnnotationConf}.
     */
    List<AnnotationConf> getAnnotations();

    /**
     * @return Список названий атрибутов, явно указанных в описании этой модели.
     */
    List<String> getAttrNames();

    /**
     * @return Полные имена расширяемых классов (для классов) или интерфейсов (для интерфейсов).
     */
    List<String> getSupersFullNames();

    /**
     * @return Список имён, указанных в блоке {@code extends} в исходном conf.
     * В отличие от {@link #getSupersFullNames}, могут вернуться как полные, так и короткие имена классов.
     */
    List<String> getExtendsList();

    /**
     * @return Полные имена всех родителей, указанных в блоках {@code extends} и {@code implements}
     * исходного conf.
     */
    List<String> getExtendsAndImplementsFullNames();

    /**
     * @return Имя файла, на основе которого была создана конфигурация
     */
    @Nullable
    String getSourceFile();

    /**
     * @return Признак того, что модели из конфигурации уже сохранены в файл
     */
    default boolean isJavaFileBuilt() {
        // Допущение: если конфигурационный файл лежит в ClassPath,
        // то он там вместе со сгенерированными из него моделями
        String sourceFile = getSourceFile();
        return sourceFile != null
                && sourceFile.contains(".jar!/");
    }
}
