package ru.yandex.direct.model.generator.old.conf;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Описание модели верхнего уровня, т.е. обладающее своим .conf файлом.
 */
@ParametersAreNonnullByDefault
public interface UpperLevelModelConf extends ModelConf {

    /**
     * @return Полные имена атрибутов вложенных моделей (интерфейсов, описанных в одном файле с классом).<br/>
     * Формат: {@link #getPackageName}.{@link #getName}.attrName
     * <p>
     * Если вложенных моделей нет, вернётся пустой список.
     */
    List<String> getNestedModelsAttributesFullPaths();

    /**
     * @return Список атрибутов, явно указанных в описании этой модели, в виде инстансов {@link AttrConf}.
     */
    List<AttrConf> getAttrs();

    /**
     * @return Полные имена атрибутов в строковом представлении.<br/>
     * Формат: {@link #getPackageName}.{@link #getName}.attrName
     */
    List<String> getAttributesFullPaths();

    /**
     * @return Список всех конфигов, в виде инстансов {@link ModelConf}. один конфиг соответвтсвует одному Spec
     */
    List<ModelConf> getAllModelConfs();
}
