package ru.yandex.direct.model.generator.old.javafile;

import java.nio.file.Paths;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;

import ru.yandex.direct.model.generator.old.spec.ClassSpec;
import ru.yandex.direct.model.generator.old.spec.EnumSpec;
import ru.yandex.direct.model.generator.old.spec.InterfaceSpec;
import ru.yandex.direct.model.generator.old.spec.JavaFileSpec;
import ru.yandex.direct.model.generator.old.spec.RelationshipSpec;

@ParametersAreNonnullByDefault
public class JavaFileFactory {

    /**
     * Сгенерировать {@link JavaFile} на основе описания {@link JavaFileSpec}.
     *
     * @param spec описание одного Java-класса (класс, интерфейс, enum) – результат обработки конфигов.
     * @return Инстанс {@link JavaFile}, готовый к записи на диск.
     */
    public JavaFile buildJavaFile(JavaFileSpec spec) {
        TypeSpec type = buildType(spec);
        return makeJavaFile(spec.getPackageName(), type, spec.getSourceFileName());
    }

    private TypeSpec buildType(JavaFileSpec spec) {
        switch (spec.getType()) {
            case CLASS:
                return new ModelClassBuilder((ClassSpec) spec).build();
            case INTERFACE:
                return new ModelInterfaceBuilder((InterfaceSpec) spec).build();
            case ENUM:
                return new ModelEnumBuilder((EnumSpec) spec).build();
            case RELATIONSHIP_MODEL:
                return new RelationshipModelClassBuilder((RelationshipSpec)spec).build();
            default:
                throw new IllegalArgumentException("Unknown java file spec type: " + spec);
        }
    }

    private JavaFile makeJavaFile(String packageName, TypeSpec spec, @Nullable String sourceFile) {
        String comment = "Auto-generated by model-generator";
        if (sourceFile != null) {
            comment += ", source: " + Paths.get(sourceFile).getFileName();
        }
        return JavaFile.builder(packageName, spec)
                .skipJavaLangImports(true)
                .indent("    ")
                .addFileComment(comment)
                .build();
    }

}
