package ru.yandex.direct.model.generator.old.javafile;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.lang.model.element.Modifier;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;

import ru.yandex.direct.model.generator.old.spec.RelationshipSpec;

import static ru.yandex.direct.model.generator.old.javafile.Util.classNameOf;

@ParametersAreNonnullByDefault
class RelationshipModelClassBuilder {
    private final RelationshipSpec spec;

    RelationshipModelClassBuilder(RelationshipSpec spec) {
        this.spec = spec;
    }

    TypeSpec build() {
        String pkg = spec.getPackageName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(spec.getClassName())
                .addAnnotation(Util.createGeneratedAnnotation(spec))
                .addJavadoc(spec.getComment() != null ? spec.getComment() : "");

        classBuilder.addModifiers(Modifier.PUBLIC);

        classBuilder.addSuperinterface(
                ParameterizedTypeName.get(classNameOf("ru.yandex.direct.model.Relationship", pkg),
                        spec.getParent(),
                        spec.getChild(),
                        spec.getParentIdType()));

        classBuilder.addMethod(makeParentIdGetter(spec.getParentIdType(), spec.getParentIdName()));
        classBuilder.addMethod(makeParentIdSetter(spec.getParentIdType(), spec.getParentIdName()));
        classBuilder.addMethod(makeParentEntityGetter(spec.getParent()));
        classBuilder.addMethod(makeChildEntityGetter(spec.getChild()));
        classBuilder.addMethod(makeEquals());
        classBuilder.addMethod(makeHashCode());

        return classBuilder.build();
    }

    private MethodSpec makeParentIdGetter(TypeName parentIdType, String parentIdName) {
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder("getParentId")
                .addAnnotation(Override.class)
                .addAnnotation(Nullable.class)
                .addParameter(spec.getChild(), "child")
                .addModifiers(Modifier.PUBLIC)
                .returns(parentIdType)
                .addStatement("return child.$L()", "get" + Util.upperCamel(parentIdName));

        return getterBuilder.build();
    }

    private MethodSpec makeParentIdSetter(TypeName parentIdType, String parentIdName) {
        MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder("setParentId")
                .addAnnotation(Override.class)
                .addParameter(spec.getChild(), "child")
                .addParameter(ParameterSpec.builder(parentIdType, "id").addAnnotation(Nullable.class).build())
                .addModifiers(Modifier.PUBLIC)
                .addStatement("child.$L(id)", "set" + Util.upperCamel(parentIdName));

        return setterBuilder.build();
    }

    private MethodSpec makeParentEntityGetter(ClassName parent) {
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder("getParentEntityClass")
                .addAnnotation(Override.class)
                .addModifiers(Modifier.PUBLIC)
                .returns(ParameterizedTypeName.get(ClassName.get(Class.class), parent))
                .addStatement("return $L.class", parent.simpleName());

        return getterBuilder.build();
    }

    private MethodSpec makeChildEntityGetter(ClassName child) {
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder("getChildEntityClass")
                .addAnnotation(Override.class)
                .addModifiers(Modifier.PUBLIC)
                .returns(ParameterizedTypeName.get(ClassName.get(Class.class), child))
                .addStatement("return $L.class", child.simpleName());

        return getterBuilder.build();
    }

    private MethodSpec makeEquals() {
        MethodSpec.Builder equalsBuilder = MethodSpec.methodBuilder("equals")
                .addAnnotation(Override.class)
                .addModifiers(Modifier.PUBLIC)
                .addParameter(Object.class, "o")
                .returns(TypeName.BOOLEAN)
                .beginControlFlow("if (this == o)")
                .addStatement("return true")
                .endControlFlow()
                .addStatement("return o != null && getClass() == o.getClass()");

        return equalsBuilder.build();
    }

    private MethodSpec makeHashCode() {
        MethodSpec.Builder equalsBuilder = MethodSpec.methodBuilder("hashCode")
                .addAnnotation(Override.class)
                .addModifiers(Modifier.PUBLIC)
                .returns(TypeName.INT)
                .addStatement("return getClass().hashCode()");

        return equalsBuilder.build();
    }
}
