package ru.yandex.direct.model.generator.old.registry;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.ClassName;

import ru.yandex.direct.model.generator.old.conf.AttrConf;

import static java.util.Objects.requireNonNull;

/**
 * Информация, необходимая для создания property holder интерфейса –
 * имя и хранимый атрибут.
 */
@ParametersAreNonnullByDefault
public class PropertyHolderMeta {

    private final ClassName className;

    private final AttrConf attr;

    private final boolean isJavaFileBuilt;

    PropertyHolderMeta(ClassName className, AttrConf attr, boolean isJavaFileBuilt) {
        this.className = requireNonNull(className);
        this.attr = requireNonNull(attr);
        this.isJavaFileBuilt = isJavaFileBuilt;
    }

    public String getFullName() {
        return className.toString();
    }

    public ClassName getClassName() {
        return className;
    }

    public AttrConf getAttr() {
        return attr;
    }

    public boolean isJavaFileBuilt() {
        return isJavaFileBuilt;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PropertyHolderMeta{");
        sb.append("className=").append(className);
        sb.append(", attr=").append(attr);
        sb.append('}');
        return sb.toString();
    }

    @Override
    @SuppressWarnings("EqualsGetClass")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PropertyHolderMeta that = (PropertyHolderMeta) o;
        return Objects.equals(className, that.className) &&
                Objects.equals(attr, that.attr);
    }

    @Override
    public int hashCode() {
        return Objects.hash(className, attr);
    }
}
