package ru.yandex.direct.model.generator.old.registry;

import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

import ru.yandex.direct.model.generator.old.conf.AttrConf;

import static java.lang.String.format;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * Фабрика имён вспомогательных property holder интерфейсов, {@link PropertyHolderMeta}.
 *
 * @see #createPropertyHolder
 */
@ParametersAreNonnullByDefault
class PropertyHolderMetaFactory {

    private static final String HOLDERS_SUBPACKAGE = "prop";
    private static final String NAME_SUFFIX = "PropHolder";

    /**
     * Создать объект {@link PropertyHolderMeta} на основе полного имени и типа атрибута.
     * <p>
     * Интерфейсы складываются в отдельный подпакет {@value #HOLDERS_SUBPACKAGE}.
     * Имя интерфейса формируется по формату:
     * <p>
     * {@code {CLASSNAME}{ATTRNAME}PropHolder},<br/>
     * <p>
     * где<br/>
     * CLASSNAME – имя класса, в котором объявлена пропертя;<br/>
     * ATTRNAME – название проперти.<br/>
     *
     * @param className имя класса, {@link ClassName}
     * @param attrName  короткое имя атрибута
     * @param attrType  тип атрибута, {@link TypeName}
     * @return Инстанс {@link PropertyHolderMeta}.
     */
    PropertyHolderMeta createPropertyHolder(ClassName className, String attrName, TypeName attrType,
                                            boolean isJavaFileBuilt) {
        AttrConf attrConf = AttrConf.of(attrName, attrType.box().toString(), className.packageName());
        String name = capitalize(className.simpleName()) + capitalize(attrName) + NAME_SUFFIX;

        return new PropertyHolderMeta(ClassName.get(getTargetPackageName(className), name), attrConf, isJavaFileBuilt);
    }


    private String getTargetPackageName(ClassName className) {
        return isBlank(className.packageName()) ?
                HOLDERS_SUBPACKAGE : format("%s.%s", className.packageName(), HOLDERS_SUBPACKAGE);
    }

}
