package ru.yandex.direct.model.generator.old.spec;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.ClassName;

import ru.yandex.direct.model.generator.old.conf.AnnotationConf;
import ru.yandex.direct.model.generator.old.conf.AttrConf;

import static java.util.Collections.emptyList;
import static java.util.Collections.unmodifiableList;

@ParametersAreNonnullByDefault
abstract class AbstractJavaFileSpec implements JavaFileSpec {

    private final ClassName className;

    private final List<AttrConf> attrs;
    private final List<AttrConf> inheritedAttrs;
    private final List<AnnotationConf> annotations;

    AbstractJavaFileSpec(ClassName className) {
        this(className, emptyList(), emptyList(), emptyList());
    }

    AbstractJavaFileSpec(ClassName className, List<AttrConf> attrs, List<AttrConf> inheritedAttrs,
                         List<AnnotationConf> annotations) {
        this.className = className;
        this.attrs = unmodifiableList(attrs);
        this.inheritedAttrs = unmodifiableList(inheritedAttrs);
        this.annotations = unmodifiableList(annotations);
    }

    public boolean isGenerateProperties() {
        return false;
    }

    @Override
    public String getName() {
        return className.simpleName();
    }

    @Override
    public String getPackageName() {
        return className.packageName();
    }

    @Override
    public String getFullName() {
        return className.toString();
    }

    @Override
    public ClassName getClassName() {
        return className;
    }

    @Override
    public List<AttrConf> getAttrs() {
        return attrs;
    }

    @Override
    public List<AnnotationConf> getAnnotations() {
        return annotations;
    }

    @Override
    public List<AttrConf> getInheritedAttributes() {
        return inheritedAttrs;
    }

}
