package ru.yandex.direct.model.generator.old.spec;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.lang.model.element.Modifier;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

import ru.yandex.direct.model.generator.old.conf.AttrConf;
import ru.yandex.direct.model.generator.old.conf.ModelClassConf;

@ParametersAreNonnullByDefault
public class ClassSpec extends AbstractJavaFileSpec {

    private final ModelClassConf conf;
    private final ClassName superClassName;
    private final List<TypeName> superInterfaces;
    private final List<AttrConf> inheritedAttrs;
    private final List<TypeName> jsonSubtypes;
    private final boolean jsonSubtypesWithNameValue;
    private final boolean generateCopyMethod;
    private final boolean superHasCopyMethod;
    private final boolean generateGetPropsMethod;

    @SuppressWarnings("checkstyle:parameternumber")
    public ClassSpec(ModelClassConf conf, List<AttrConf> inheritedAttrs, List<TypeName> superInterfaces,
                     @Nullable ClassName superClassName, List<TypeName> jsonSubtypes, boolean jsonSubtypesWithNameValue,
                     boolean generateCopyMethod, boolean superHasCopyMethod, boolean generateGetPropsMethod
    ) {
        super(conf.getClassName(), conf.getAttrs(), inheritedAttrs, conf.getAnnotations());

        this.conf = conf;
        this.superClassName = superClassName;
        this.superInterfaces = superInterfaces;
        this.inheritedAttrs = inheritedAttrs;
        this.jsonSubtypes = jsonSubtypes;
        this.jsonSubtypesWithNameValue = jsonSubtypesWithNameValue;
        this.generateCopyMethod = generateCopyMethod;
        this.superHasCopyMethod = superHasCopyMethod;
        this.generateGetPropsMethod = generateGetPropsMethod;
    }

    @Override
    public Type getType() {
        return Type.CLASS;
    }

    @Override
    public String getSourceFileName() {
        return conf.getSourceFile();
    }

    @Override
    public String getComment() {
        return conf.getComment();
    }

    @Override
    public List<AttrConf> getInheritedAttributes() {
        return inheritedAttrs;
    }

    public String getExtends() {
        return conf.getExtendsClass();
    }

    @Nullable
    public ClassName getExtendsClassName() {
        return superClassName;
    }

    public List<TypeName> getSuperInterfaces() {
        return superInterfaces;
    }

    public List<Modifier> getModifiers() {
        return conf.getModifiers();
    }

    public List<TypeName> getJsonSubtypes() {
        return jsonSubtypes;
    }

    public boolean isJsonSubtypesWithNameValue() {
        return jsonSubtypesWithNameValue;
    }

    public boolean isGenerateGetPropsMethod() {
        return generateGetPropsMethod;
    }

    public boolean isGenerateCopyMethod() {
        return generateCopyMethod;
    }

    public boolean isSuperHasCopyMethod() {
        return superHasCopyMethod;
    }
}
