package ru.yandex.direct.model.generator.old.spec;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.ClassName;

import ru.yandex.direct.model.generator.old.conf.EnumConf;
import ru.yandex.direct.model.generator.old.conf.EnumValueConf;

@ParametersAreNonnullByDefault
public class EnumSpec extends AbstractJavaFileSpec implements JavaFileSpec {

    private final EnumConf conf;
    private final String sourceFileName;

    public EnumSpec(EnumConf conf, ClassName className, @Nullable String sourceFileName) {
        super(className);
        this.conf = conf;
        this.sourceFileName = sourceFileName;
    }

    @Override
    public Type getType() {
        return Type.ENUM;
    }

    @Nullable
    @Override
    public String getSourceFileName() {
        return sourceFileName;
    }

    @Override
    public String getComment() {
        return conf.getComment();
    }

    public String getValuesSource() {
        return conf.getValuesSource();
    }

    public String getValuesType() {
        return conf.getValuesType();
    }

    public List<EnumValueConf> getValues() {
        return conf.getValues();
    }
}
