package ru.yandex.direct.model.generator.old.spec;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

import ru.yandex.direct.model.generator.old.conf.AnnotationConf;
import ru.yandex.direct.model.generator.old.conf.AttrConf;
import ru.yandex.direct.model.generator.old.conf.InterfaceConf;
import ru.yandex.direct.model.generator.old.conf.ModelInterfaceConf;

import static java.util.Collections.emptyList;
import static java.util.Collections.unmodifiableList;
import static java.util.stream.Collectors.toList;

/**
 * @inheritDoc Описывает интерфейс. Неважно, самостоятельно описанный, вложенный в .conf класса
 * или служебный интерфейс.
 */
@ParametersAreNonnullByDefault
public class InterfaceSpec extends AbstractJavaFileSpec {

    private final String sourceFileName;
    private final String comment;
    private final List<TypeName> superInterfaces;
    private final List<TypeName> jsonSubtypes;
    private final boolean jsonSubtypesWithNameValue;
    private final boolean readOnly;
    private final boolean generateGetPropsMethod;

    public InterfaceSpec(InterfaceConf conf, ClassName className,
                         List<AttrConf> attrs, List<AttrConf> inheritedAttrs,
                         List<TypeName> superInterfaces,
                         List<AnnotationConf> annotations,
                         List<TypeName> jsonSubtypes, boolean jsonSubtypesWithNameValue, boolean readOnly, boolean generateGetPropsMethod) {
        super(className, attrs, inheritedAttrs, annotations);

        this.sourceFileName = conf.getSourceFile();
        this.comment = conf.getComment();
        this.superInterfaces = unmodifiableList(superInterfaces);
        this.jsonSubtypes = jsonSubtypes;
        this.jsonSubtypesWithNameValue = jsonSubtypesWithNameValue;
        this.readOnly = readOnly;
        this.generateGetPropsMethod = generateGetPropsMethod;
    }

    public InterfaceSpec(ModelInterfaceConf conf, List<AttrConf> inheritedAttrs, List<TypeName> superInterfaces,
                         List<AnnotationConf> annotations, List<TypeName> jsonSubtypes, boolean jsonSubtypesWithNameValue,
                         boolean readOnly, boolean generateGetPropsMethod) {
        super(conf.getClassName(), conf.getAttrs(), inheritedAttrs, annotations);

        this.sourceFileName = conf.getSourceFile();
        this.comment = conf.getComment();
        this.superInterfaces = unmodifiableList(superInterfaces);
        this.jsonSubtypes = jsonSubtypes;
        this.jsonSubtypesWithNameValue = jsonSubtypesWithNameValue;
        this.readOnly = readOnly;
        this.generateGetPropsMethod = generateGetPropsMethod;
    }

    InterfaceSpec(ClassName className, List<AttrConf> attrs, String comment) {
        super(className, attrs, emptyList(), emptyList());

        this.sourceFileName = null;
        this.comment = comment;
        this.superInterfaces = emptyList();
        this.jsonSubtypes = emptyList();
        this.jsonSubtypesWithNameValue = false;
        this.readOnly = false;
        this.generateGetPropsMethod = false;
    }

    public List<String> getAttrNames() {
        return toNames(getAttrs());
    }

    private static List<String> toNames(List<AttrConf> attrConf) {
        return attrConf.stream().map(AttrConf::getName).collect(toList());
    }

    public boolean isReadOnly() {
        return readOnly;
    }

    public boolean isGenerateGetPropsMethod() {
        return generateGetPropsMethod;
    }

    @Override
    public Type getType() {
        return Type.INTERFACE;
    }

    @Override
    @Nullable
    public String getSourceFileName() {
        return sourceFileName;
    }

    @Override
    public String getComment() {
        return comment;
    }

    public List<TypeName> getSuperInterfaces() {
        return superInterfaces;
    }

    public List<TypeName> getJsonSubtypes() {
        return jsonSubtypes;
    }

    public boolean isJsonSubtypesWithNameValue() {
        return jsonSubtypesWithNameValue;
    }

}
