package ru.yandex.direct.model.generator.old.spec;

import java.util.List;
import java.util.Optional;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.ClassName;

import ru.yandex.direct.model.generator.old.conf.AnnotationConf;
import ru.yandex.direct.model.generator.old.conf.AttrConf;
import ru.yandex.direct.model.generator.old.conf.UpperLevelModelConf;
import ru.yandex.direct.model.generator.old.javafile.JavaFileFactory;
import ru.yandex.direct.model.generator.old.util.FullClassNameProvider;

/**
 * Интерфейс, по которому фабрика {@link JavaFileFactory}
 * создаёт объекты {@link com.squareup.javapoet.JavaFile}
 * для последующией записи на диск.
 * <p>
 * Отличие от {@link UpperLevelModelConf} в том,
 * что имплементации данного интерфейса снабжены всей необходимой информацией
 * о своих суперклассах и суперинтерфейсах, а также атрибутах, которые от них унаследованы,
 * и фабрике больше ничего не требуется для генерации файлов.
 */
@ParametersAreNonnullByDefault
public interface JavaFileSpec extends FullClassNameProvider {

    enum Type {
        CLASS,
        INTERFACE,
        ENUM,
        RELATIONSHIP_MODEL
    }

    Type getType();

    /**
     * @return Если описание создано на основе файла конфигурации, вернётся {@link Optional}
     * с именем файла, иначе {@link Optional#empty}.
     */
    @Nullable
    String getSourceFileName();

    /**
     * @return Короткое имя класса.
     */
    String getName();

    /**
     * @return Полное имя пакета.
     */
    String getPackageName();

    /**
     * @return Комментарий, указанный в исходнике, для генерации Javadoc.
     */
    String getComment();

    /**
     * @return Имя класса в виде инстанса {@link ClassName}.
     */
    ClassName getClassName();

    /**
     * @return Список атрибутов, явно указанных в описании этой модели, в виде инстансов {@link AttrConf}.
     */
    List<AttrConf> getAttrs();

    /**
     * @return Список аннотаций, явно указанных в описании этой модели, в виде инстансов {@link AnnotationConf}.
     */
    List<AnnotationConf> getAnnotations();

    /**
     * @return Список всех унаследованных атрибутов, {@link AttrConf}.
     */
    List<AttrConf> getInheritedAttributes();

}
