package ru.yandex.direct.model.generator.old.spec;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Objects;
import com.squareup.javapoet.ClassName;

import ru.yandex.direct.model.generator.old.conf.AttrConf;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.model.generator.old.spec.JavaFileSpec.Type.INTERFACE;

@ParametersAreNonnullByDefault
public class PropertyHolderInterfaceSpec extends InterfaceSpec implements JavaFileSpec {

    private static final String JAVADOC_STRING =
            "Auxiliary generated interface. Please do NOT reference it directly!\n";

    private final AttrConf attr;

    public PropertyHolderInterfaceSpec(ClassName className, AttrConf attr) {
        super(className, singletonList(attr), JAVADOC_STRING);
        this.attr = attr;
    }

    @Override
    public boolean isGenerateProperties() {
        return true;
    }

    @Override
    public Type getType() {
        return INTERFACE;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    @SuppressWarnings("EqualsGetClass")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PropertyHolderInterfaceSpec that = (PropertyHolderInterfaceSpec) o;
        return Objects.equal(attr, that.attr)
                && Objects.equal(getFullName(), getFullName());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(attr, getFullName());
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("PropertyHolderInterfaceSpec{");
        sb.append(", attr=").append(attr);
        sb.append('}');
        return sb.toString();
    }
}
