package ru.yandex.direct.model.generator.old.spec;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

import ru.yandex.direct.model.generator.old.conf.AnnotationConf;
import ru.yandex.direct.model.generator.old.conf.AttrConf;
import ru.yandex.direct.model.generator.old.conf.RelationshipConf;

/**
 * @inheritDoc Описывает объект связи между двумя сущностями - Relationship
 */
@ParametersAreNonnullByDefault
public class RelationshipSpec implements JavaFileSpec {
    private final ClassName className;
    private final ClassName parent;
    private final ClassName child;
    private final TypeName parentIdType;
    private final String parentIdName;
    private String sourceFileName;

    public RelationshipSpec(RelationshipConf conf) {
        this.className = conf.getClassName();
        this.parent = conf.getParent();
        this.child = conf.getChildClass();
        this.parentIdType = conf.getParentIdType();
        this.parentIdName = conf.getParentIdName();
        this.sourceFileName = conf.getSourceFile();
    }

    @Override
    public ClassName getClassName() {
        return className;
    }

    @Override
    public List<AttrConf> getAttrs() {
        return List.of();
    }

    @Override
    public List<AnnotationConf> getAnnotations() {
        return List.of();
    }

    @Override
    public List<AttrConf> getInheritedAttributes() {
        return List.of();
    }

    public ClassName getParent() {
        return parent;
    }

    @Override
    public Type getType() {
        return Type.RELATIONSHIP_MODEL;
    }

    @Nullable
    @Override
    public String getSourceFileName() {
        return sourceFileName;
    }

    @Override
    public String getName() {
        return className.simpleName();
    }

    @Override
    public String getPackageName() {
        return className.packageName();
    }

    @Override
    public String getComment() {
        return "";
    }

    public ClassName getChild() {
        return child;
    }

    public TypeName getParentIdType() {
        return parentIdType;
    }

    public String getParentIdName() {
        return parentIdName;
    }

    @Override
    public String getFullName() {
        return className.toString();
    }
}
