package ru.yandex.direct.model.generator.old.spec.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import one.util.streamex.StreamEx;

import ru.yandex.direct.model.generator.old.conf.AttrConf;
import ru.yandex.direct.model.generator.old.conf.InterfaceConf;
import ru.yandex.direct.model.generator.old.conf.ModelClassConf;
import ru.yandex.direct.model.generator.old.conf.ModelConf;
import ru.yandex.direct.model.generator.old.javafile.Util;
import ru.yandex.direct.model.generator.old.registry.ModelConfRegistry;
import ru.yandex.direct.model.generator.old.registry.PropertyHolderMeta;
import ru.yandex.direct.model.generator.old.spec.ClassSpec;

import static ru.yandex.direct.utils.FunctionalUtils.flatMap;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
class ClassSpecFactory {

    private final ModelConfRegistry registry;

    ClassSpecFactory(ModelConfRegistry registry) {
        this.registry = registry;
    }

    ClassSpec createClassSpec(ModelClassConf conf) {
        ClassName superClassName = null;
        if (!conf.getExtendsClass().isEmpty()) {
            superClassName = Util.classNameOf(conf.getExtendsClass(), conf.getPackageName());
        }

        List<TypeName> superInterfaces = new ArrayList<>();

        StreamEx.of(conf.getInterfaces())
                .map(InterfaceConf::getName)
                .append(conf.getImplementsList())
                .distinct()
                .map(interfaceName -> getInterfaceConf(conf, interfaceName))
                .forEach(superInterfaces::add);

        if (conf.isGenerateProperties()) {
            conf.getAttributesFullPaths().stream()
                    .map(registry::getPropertyHolder)
                    .filter(Objects::nonNull)
                    .map(PropertyHolderMeta::getClassName)
                    .forEach(superInterfaces::add);
        }

        List<TypeName> jsonSubtypes = conf.isJsonSubtypes() || conf.isJsonSubtypesWithNameValue()
                ? mapList(registry.getSubtypes(conf), ModelConf::getClassName)
                : Collections.emptyList();

        List<AttrConf> inheritedAttrs = flatMap(registry.getClassAncestors(conf), ModelClassConf::getAttrs);

        boolean ancestorHasCopyMethod = registry.isClassAncestorsHasCopyMethod(conf);
        boolean generateCopyMethod = ancestorHasCopyMethod || conf.isGenerateCopyMethod();
        boolean generateGetPropsMethod = conf.isGenerateProperties();

        return new ClassSpec(conf, inheritedAttrs, superInterfaces, superClassName, jsonSubtypes,
                conf.isJsonSubtypesWithNameValue(), generateCopyMethod, ancestorHasCopyMethod, generateGetPropsMethod);
    }

    private TypeName getInterfaceConf(ModelClassConf conf, String interfaceName) {
        return Util.typeNameOf(interfaceName, conf.getPackageName());
    }
}
