package ru.yandex.direct.model.generator.old.spec.factory;

import java.util.Set;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.model.generator.old.conf.EnumConf;
import ru.yandex.direct.model.generator.old.conf.InterfaceConf;
import ru.yandex.direct.model.generator.old.conf.ModelClassConf;
import ru.yandex.direct.model.generator.old.conf.ModelConf;
import ru.yandex.direct.model.generator.old.conf.ModelInterfaceConf;
import ru.yandex.direct.model.generator.old.conf.RelationshipConf;
import ru.yandex.direct.model.generator.old.registry.ModelConfRegistry;
import ru.yandex.direct.model.generator.old.registry.PropertyHolderMeta;
import ru.yandex.direct.model.generator.old.spec.InterfaceSpec;
import ru.yandex.direct.model.generator.old.spec.JavaFileSpec;
import ru.yandex.direct.model.generator.old.spec.RelationshipSpec;

import static java.util.stream.Collectors.toSet;

@ParametersAreNonnullByDefault
public class JavaFileSpecFactory {

    private final ModelConfRegistry registry;

    private final ClassSpecFactory classSpecFactory;
    private final InterfaceSpecFactory interfaceSpecFactory;
    private final EnumSpecFactory enumSpecFactory;

    public JavaFileSpecFactory(ModelConfRegistry registry) {
        this.registry = registry;

        this.classSpecFactory = new ClassSpecFactory(registry);
        this.interfaceSpecFactory = new InterfaceSpecFactory(registry);
        this.enumSpecFactory = new EnumSpecFactory();
    }

    /**
     * На основе конфигов, занесённых в {@link ModelConfRegistry}, сгенерировать
     * описания java-файлов, {@link JavaFileSpec}, используя информацию из {@link ModelConfRegistry}.
     *
     * @return Описания всех файлов, которые нужно сгенерировать на основе имеющихся конфигов.
     */
    public Set<JavaFileSpec> convertAllConfigsToSpecs() {
        return StreamEx.of(registry.getAllModelConfigs())
                .remove(ModelConf::isJavaFileBuilt)
                .map(this::confToSpec)
                .append(createPropertyHoldersSpecs())
                .collect(toSet());
    }

    private Stream<InterfaceSpec> createPropertyHoldersSpecs() {
        return StreamEx.of(registry.getAllPropertyHoldersMeta())
                .remove(PropertyHolderMeta::isJavaFileBuilt)
                .map(interfaceSpecFactory::createInterfaceSpec);
    }

    private JavaFileSpec confToSpec(ModelConf conf) {
        switch (conf.getType()) {
            case CLASS:
                return classSpecFactory.createClassSpec((ModelClassConf) conf);
            case INTERFACE:
                if (conf instanceof ModelInterfaceConf) {
                    return interfaceSpecFactory.createInterfaceSpec((ModelInterfaceConf) conf);
                } else if (conf instanceof InterfaceConf) {
                    return interfaceSpecFactory.createInterfaceSpec((InterfaceConf) conf);
                } else {
                    throw new IllegalArgumentException("Unknown interface conf class: " + conf.getClassName());
                }
            case ENUM:
                return enumSpecFactory.createEnumSpec((EnumConf) conf);
            case RELATIONSHIP_MODEL:
                return new RelationshipSpec((RelationshipConf)conf);
            default:
                throw new IllegalArgumentException("Unknown conf type: " + conf.getType());
        }
    }
}
