package ru.yandex.direct.model.generator.old.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.generator.old.conf.AttrConf;

@ParametersAreNonnullByDefault
public class AttrNameUtil {
    private static final String DOT = ".";

    private AttrNameUtil() {
    }

    /**
     * Получить короткое имя атрибута по полному имени.
     *
     * @param attrFullName полное имя атрибута, формат {@code ПАКЕТ.КЛАСС.АТРИБУТ}
     * @return Подстроку от исходной строки после последней точки.
     */
    public static String getAttrShortName(String attrFullName) {
        return attrFullName.substring(attrFullName.lastIndexOf(DOT) + 1);
    }

    /**
     * Получить полное имя атрибута.
     *
     * @param attr описание атрибута, {@link AttrConf}.
     * @param conf объект, возвращающий полное имя класса; предположительно, описание модели.
     * @return Строка в формате {@code ПАКЕТ.КЛАСС.АТРИБУТ}
     */
    public static String getAttrFullName(AttrConf attr, FullClassNameProvider conf) {
        return String.join(DOT, conf.getFullName(), attr.getName());
    }

    /**
     * Получить полное имя атрибута.
     *
     * @param attrShortName короткое имя атрибута.
     * @param conf          объект, возвращающий полное имя класса; предположительно, описание модели.
     * @return Строка в формате {@code ПАКЕТ.КЛАСС.АТРИБУТ}
     */
    public static String getAttrFullName(String attrShortName, FullClassNameProvider conf) {
        return String.join(DOT, conf.getFullName(), attrShortName);
    }
}
