package ru.yandex.direct.model.generator.rewrite.builder

import com.squareup.javapoet.JavaFile
import com.squareup.javapoet.TypeSpec
import ru.yandex.direct.model.generator.rewrite.spec.ClassSpec
import ru.yandex.direct.model.generator.rewrite.spec.EnumSpec
import ru.yandex.direct.model.generator.rewrite.spec.InterfaceSpec
import ru.yandex.direct.model.generator.rewrite.spec.RelationshipSpec
import ru.yandex.direct.model.generator.rewrite.spec.Spec
import java.nio.file.Paths

class Builder {
    fun buildJavaFile(spec: Spec): JavaFile {
        val comment = if (spec.sourceFile != null) {
            val fileName = Paths.get(spec.sourceFile!!).fileName
            "Auto-generated by model-generator, source: $fileName"
        } else {
            "Auto-generated by model-generator"
        }

        val typeSpec = buildType(spec)
        return JavaFile.builder(spec.name.packageName(), typeSpec)
            .skipJavaLangImports(true)
            .indent("    ")
            .addFileComment(comment)
            .build()
    }

    private fun buildType(spec: Spec): TypeSpec {
        return when (spec) {
            is ClassSpec -> ClassBuilder(spec).build()
            is InterfaceSpec -> InterfaceBuilder(spec).build()
            is RelationshipSpec -> RelationshipBuilder(spec).build()
            is EnumSpec -> EnumBuilder(spec).build()
            else -> throw NotImplementedError("Unknown spec type: $spec")
        }
    }
}

