package ru.yandex.direct.model.generator.rewrite.conf

import com.typesafe.config.Config
import com.typesafe.config.ConfigValue

fun Config.getStringOrNull(path: String): String? {
    return if (hasPath(path)) getString(path) else null
}

fun Config.getBooleanOrFalse(path: String): Boolean {
    return if (hasPath(path)) getBoolean(path) else false
}

fun Config.getBooleanOrTrue(path: String): Boolean {
    return if (hasPath(path)) getBoolean(path) else true
}

fun Config.getStringListOrNull(path: String): List<String>? {
    return if (hasPath(path)) getStringList(path) else null
}

fun Config.getStringListOrEmpty(path: String): List<String> {
    return if (hasPath(path)) getStringList(path) else listOf()
}

fun Config.getListOrEmpty(path: String): List<ConfigValue> {
    return if (hasPath(path)) getList(path) else listOf()
}

fun Config.getConfigOrNull(path: String): Config? {
    return if (hasPath(path)) getConfig(path) else null
}

fun Config.getConfigListOrEmpty(path: String): List<Config> {
    return if (hasPath(path)) getConfigList(path) else listOf()
}
