package ru.yandex.direct.model.generator.rewrite.spec

import ru.yandex.direct.model.generator.rewrite.JavaPoetUtils
import ru.yandex.direct.model.generator.rewrite.conf.EnumConf

class EnumSpecFactory {
    fun createEnumSpec(conf: EnumConf): EnumSpec {
        return EnumSpec(
            name = JavaPoetUtils.toClassName(conf.name, conf.packageName),
            comment = conf.comment,
            sourceFile = conf.sourceFile,

            valuesSource = conf.valuesSource
                ?.let { JavaPoetUtils.toClassName(it, conf.packageName) },
            valuesType = conf.valuesType
                ?.let { JavaPoetUtils.toTypeName(it, conf.packageName) },
            values = conf.values,
        )
    }
}
