package ru.yandex.direct.model.generator.rewrite.spec

import ru.yandex.direct.model.generator.rewrite.JavaPoetUtils
import ru.yandex.direct.model.generator.rewrite.conf.RelationshipConf

class RelationshipSpecFactory {
    fun createRelationshipSpec(conf: RelationshipConf): RelationshipSpec {
        return RelationshipSpec(
            name = JavaPoetUtils.toClassName(conf.name, conf.packageName),
            comment = conf.comment,
            sourceFile = conf.sourceFile,

            parent = JavaPoetUtils.toClassName(conf.parent, conf.packageName),
            child = JavaPoetUtils.toClassName(conf.child, conf.packageName),

            parentIdField = conf.parentIdField,
            parentIdType = JavaPoetUtils.toTypeName(conf.parentIdType, conf.packageName),
        )
    }
}
