package ru.yandex.direct.model.generator.rewrite.spec

import ru.yandex.direct.model.generator.rewrite.ModelRegistry
import ru.yandex.direct.model.generator.rewrite.PropertyResolver
import ru.yandex.direct.model.generator.rewrite.conf.Conf
import ru.yandex.direct.model.generator.rewrite.conf.EnumConf
import ru.yandex.direct.model.generator.rewrite.conf.InnerInterfaceConf
import ru.yandex.direct.model.generator.rewrite.conf.ModelClassConf
import ru.yandex.direct.model.generator.rewrite.conf.ModelInterfaceConf
import ru.yandex.direct.model.generator.rewrite.conf.RelationshipConf
import ru.yandex.direct.model.generator.rewrite.conf.isAlreadyBuilt

class SpecFactory(
    registry: ModelRegistry,
    private val propertyResolver: PropertyResolver,
) {
    private val classSpecFactory = ClassSpecFactory(registry, propertyResolver)
    private val interfaceSpecFactory = InterfaceSpecFactory(registry, propertyResolver)
    private val relationshipSpecFactory = RelationshipSpecFactory()
    private val enumSpecFactory = EnumSpecFactory()

    fun convertAllConfigsToSpecs(configs: Collection<Conf>): Set<Spec> {
        val specs = configs
            .filter { !it.isAlreadyBuilt() }
            .map { convertToSpec(it) }
            .toSet()
        val propHolders = propertyResolver.allPropHolders()
            .filter { !it.isAlreadyBuilt }
            .map { interfaceSpecFactory.createPropHolderInterfaceSpec(it) }
        return specs + propHolders
    }

    private fun convertToSpec(conf: Conf): Spec {
        return when (conf) {
            is ModelClassConf -> classSpecFactory.createClassSpec(conf)
            is ModelInterfaceConf -> interfaceSpecFactory.createInterfaceSpec(conf)
            is InnerInterfaceConf -> interfaceSpecFactory.createInnerInterfaceSpec(conf)
            is RelationshipConf -> relationshipSpecFactory.createRelationshipSpec(conf)
            is EnumConf -> enumSpecFactory.createEnumSpec(conf)
            else -> throw NotImplementedError()
        }
    }
}
