package ru.yandex.direct.model.generator.rewrite.spec

import com.squareup.javapoet.ClassName
import com.squareup.javapoet.TypeName
import ru.yandex.direct.model.generator.rewrite.conf.AnnotationConf
import ru.yandex.direct.model.generator.rewrite.conf.AttributeConf
import ru.yandex.direct.model.generator.rewrite.conf.EnumValueConf
import javax.lang.model.element.Modifier

interface Spec {
    val name: ClassName
    val comment: String?
    val sourceFile: String?
}

data class ClassSpec(
    override val name: ClassName,
    override val comment: String?,
    override val sourceFile: String,

    val annotations: List<AnnotationConf>,
    val jsonSubtypes: List<TypeName>,
    val jsonSubtypeNames: Boolean,

    val modifiers: List<Modifier>,

    val extends: TypeName?,
    val implements: List<TypeName>,

    val modelProperties: List<AttributeConf>,
    val inheritedAttributes: List<AttributeConf>,
    val attributes: List<AttributeConf>,

    val generateAllModelProperties: Boolean,

    val generateCopy: Boolean,
    val superHasCopy: Boolean,
) : Spec

data class InterfaceSpec(
    override val name: ClassName,
    override val comment: String?,
    override val sourceFile: String?,

    val annotations: List<AnnotationConf>,
    val jsonSubtypes: List<TypeName>,
    val jsonSubtypeNames: Boolean,

    val extends: List<TypeName>,

    val readonly: Boolean,
    val modelProperties: List<AttributeConf>,
    val attributes: List<AttributeConf>,
    val inheritedAttributes: List<AttributeConf>,

    val generateAllModelProperties: Boolean,
) : Spec

data class RelationshipSpec(
    override val name: ClassName,
    override val comment: String?,
    override val sourceFile: String,

    val parent: ClassName,
    val child: ClassName,

    val parentIdField: String,
    val parentIdType: TypeName,
) : Spec

data class EnumSpec(
    override val name: ClassName,
    override val comment: String?,
    override val sourceFile: String,

    val valuesSource: ClassName?,
    val valuesType: TypeName?,
    val values: List<EnumValueConf>,
) : Spec
