package ru.yandex.direct.model.generator.rewrite.spec

import com.squareup.javapoet.ClassName
import com.squareup.javapoet.TypeName
import ru.yandex.direct.model.Model
import ru.yandex.direct.model.ModelWithId
import ru.yandex.direct.model.generator.rewrite.JavaPoetUtils
import ru.yandex.direct.model.generator.rewrite.ModelRegistry
import ru.yandex.direct.model.generator.rewrite.conf.AttributeConf
import ru.yandex.direct.model.generator.rewrite.conf.InnerInterfaceConf
import ru.yandex.direct.model.generator.rewrite.conf.UpperLevelConf
import ru.yandex.direct.model.generator.rewrite.conf.WithJsonSubtypes

object SpecUtils {
    fun hasIdAttribute(attributes: List<AttributeConf>): Boolean =
        attributes.any {
            it.name == "id" && it.type == TypeName.get(java.lang.Long::class.java)
        }

    fun modelInterface(attributes: List<AttributeConf>): TypeName =
        if (hasIdAttribute(attributes)) {
            ClassName.get(ModelWithId::class.java)
        } else {
            ClassName.get(Model::class.java)
        }

    fun jsonSubtypes(conf: WithJsonSubtypes, registry: ModelRegistry): List<TypeName> =
        if (conf.jsonSubtypes || conf.jsonSubtypeNames) {
            registry.getSubtypes(conf)
                .filterIsInstance<UpperLevelConf>()
                .map { JavaPoetUtils.toTypeName(it.name, it.packageName) }
        } else {
            listOf()
        }
}
