package ru.yandex.direct.model.generator.rewrite

import com.google.common.base.CaseFormat

/**
 * Converts attribute name to upper camel case.
 *
 * For example `exampleAttribute` -> `ExampleAttribute`
 */
fun String.upperCamel(): String {
    return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, this)
}

/**
 * Converts attribute name to upper underscore case.
 *
 * For example `exampleAttribute` -> `EXAMPLE_ATTRIBUTE`
 */
fun String.upperUnderscore(): String {
    return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, this)
}
