package ru.yandex.direct.model.generator.uf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import static java.util.Collections.unmodifiableList;

/**
 * Базовый класс для решения DSU.
 * <p>
 * При инициализации создаёт лес из N деревьев,
 * где N – число элементов,
 * т.е. каждый элемент представляет отдельное множество,
 * будучи корнем единичного дерева.
 *
 * @see UnionFind
 */
@ParametersAreNonnullByDefault
abstract class AbstractUnionFind<E> implements UnionFind<E> {

    final List<E> items;
    final Map<E, Integer> index;

    AbstractUnionFind(Collection<E> items) {
        index = new HashMap<>(items.size());
        List<E> init = new ArrayList<>(items.size());

        int i = 0;
        for (E item : items) {
            init.add(item);
            index.put(item, i++);
        }
        this.items = unmodifiableList(init);
    }

}
