package ru.yandex.direct.model.generator.uf;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class QuickUnion<E> extends AbstractUnionFind<E> {

    QuickUnion(Collection<E> items) {
        super(items);
    }

    @Override
    public void connect(E p, E q) {
        mergeFirstToSecond(root(p), root(q));
    }

    /**
     * Первое множество включается во второе.
     *
     * @param firstRoot  корень первого множества,
     *                   индекс которого будет переназначен
     * @param secondRoot корень второго, целевого, множества
     */
    void mergeFirstToSecond(E firstRoot, E secondRoot) {
        index.put(firstRoot, index.get(secondRoot));
    }

    @Override
    public boolean connected(E p, E q) {
        return root(p) == root(q);
    }

    @SuppressWarnings("squid:S1226")
    E root(E p) {
        while (!isRoot(p)) {
            p = parent(p);
        }
        return p;
    }

    E parent(E p) {
        Integer id = index.get(p);
        return items.get(id);
    }

    /**
     * Корнем дерева считается элемент, который сам себе родитель.
     */
    boolean isRoot(E p) {
        return p == parent(p);
    }

    @Override
    public int find(E p) {
        return index.get(root(p));
    }

    @Override
    public int count() {
        return (int) index.keySet().stream().filter(this::isRoot).count();
    }
}
